.nolist
.origin $1000
screen = $0400
putc   = $ffd2
plot   = $fff0
stop   = $ffe1
setlfs = $ffba
setnam = $ffbd
open   = $ffc0
chkin  = $ffc6
getin  = $ffe4
chkout = $ffc9
close  = $ffc3
clrchn = $ffcc
rsstat = $0297
readst = $ffb7
listen = $ffb1
line   = $dd01  ;controls DTR, etc.
second = $ff93  ;for printer
ciout  = $ffa8
unlsn  = $ffae
minutes= $dc0a  ;stored by TOD clock
ptr    = $fb    ;zp pointer for printing
bufptr = $fd    ;zp pointer for buffer
ctrlreg= $0293  ;data and stop bits (40)
cmdreg = $0294  ;parity and handsk (97)

jmp BEGINNING
carriage:  .byte 0
ystore: .byte 0
pry:    .byte 0
prname: .byte 0,0
fname:  .byte 40, 97
;com1:e,7,1  x-line handshake
array: .blkb 128
BEGINNING:
jsr SETUP
jsr SETARRAY
jsr OPEN232
NEXTLINE:
ldx #12
ldy #0
clc
jsr plot    ;move cursor
lda line           
ora #2     ;raise DTR. Ready to receive
sta line
WAIT:
jsr getin   ;grab anything in the port
cmp #13
beq DROP    ;drop DTR, that is
cmp #0
bne FOUND.ONE
lda rsstat
sta screen+216
jsr  $ffea  ;PRG says you need this one
jsr stop    ;to scan the stop key
bne WAIT
rts         ;break if STOP pressed
FOUND.ONE:  ;ok, then translate it
jmp TRANSLATE ;into petscii
OK:
ldy ystore  ;get last value of y
sta (bufptr),y  ;put it in buffer
sta screen-1       ;temporary of course
iny
sty ystore
jsr putc    ;print it to the screen
lda screen-1    ; putc alters Accumul.
nop
.print * getstat  
GETSTAT:
ldx carriage
cpx #$ff    ;$ff is my EOL marker
bne WAIT
jsr DOUBLECHECK ;anything else received
jsr clrchn      ;clear channels
jsr PLINE       ;print line
jsr clrchn
jsr REOPEN232   ;setup 232
jsr CLRLN       ;clear the last line
jmp NEXTLINE    ;off the screen

TRANSLATE:
and #127    ;allowing for a few weird
tax
sec
sbc #31     ;array offset by 32
nop
bcc FEED
tay
dey
lda array,y ;loading in the petscii 
TRANOK: jmp OK
TRAEND: jmp WAIT ;and go back
FEED:
txa
cmp #12
beq DROP  
cmp #13
bne TRAEND  ;12 and 13 are the only 
DROP:tax    ;valid characters <32       
lda line    ;
and #253    ;drop RTS
sta line
lda #$ff    ;put EOL mark
sta carriage
lda #122        ;checkmark
sta screen + 282
lda #32
sta screen + 202
txa
jmp OK

.print * pline
PLINE:
lda #122        ;move checkmark
sta screen + 221
lda #32
sta screen + 301
nop
jsr OPENPR
ldy #0
sty pry
LOOP = *
ldy pry
lda (bufptr),y  ;get char from buffer
iny
sty pry
cmp #$ff        ;until EOL
beq RAUS
jsr ciout       ;print it
jsr readst
sta screen+233
jmp LOOP
RAUS: jsr UNLYSNA
rts

SETARRAY:   ;elements cmb, subscrps IBM
ldx #32     ;first element in array
ldy #0      ;first subscript
Loop = *
txa         ;easier to address
sta array,y ;put it at top of code array
iny
inx         ;add one
cpx #65     ;translation changes at 65
bne Loop
nop
ldx #97 ;upper case, x=65,
Loop = *
txa         ;easier to address
sta array,y ;put it at top of code array
iny         ;y was inc'ed coming in.
inx         ;add one
cpx #123    ;translation changes at 123
bne Loop
nop
lda #91     ;a few irregulars here
sta array, y    ;left bracket
iny         ;y was = 91 too
lda #47     ;backslash
sta array,y
iny
lda  #93    ;right bracket
sta array,y
iny
lda #94     ;caret
sta array,y
iny
lda #45     ;minus sign 
sta array,y
iny
lda #39
sta array,y ;reverse accent mark
iny         ;now y=97-32
ldx #65
Loop = *
txa         ;easier to address
sta array,y ;put it at top of code array
iny
inx         ;add one
cpx #91     ;translation ends at 90
bne Loop
nop
rts         ;go back whence ye came 
nop

.print * unlysna
UNLYSNA:        ;unlisten the printer
nop
lda #32         ;move checkmark
sta screen+221
lda #122
sta screen+301
jsr unlsn       ;kernal routine
jsr readst
sta screen+313
lda #4
jsr close
sta screen+314
jsr readst
sta screen+315
rts


OPEN232:
lda #$70        ;beginning of my buffer
sta bufptr+1    ;$7000 stored in $fd,fe
lda #$00
sta bufptr
lda #$28    ;decimal 40
sta ctrlreg ;7 data, 1 stop
lda #$61    ;even parity, x-line
sta cmdreg  ;decimal 97
lda #0      ;length of filename
.print * loading fname
.print fname
.print fname+1
ldx fname  ;LB fname address
ldy fname+1;HB fname address
jsr setnam  ;page 298
lda #05     ;lf number for RS232
ldx #02     ;device#2
ldy #03     ;channel #3
jsr setlfs  ;page 297
jsr open    ;page 289
sta screen+214
jsr readst
sta screen+215
REOPEN232:
.print * reopen
ldx #05     ;lf number
jsr chkin   ;initialize for input
sta screen+254
ldy #0
sty ystore
sty carriage
lda #32         ;move checkmark
sta screen+282
lda #122
sta screen+202
rts

OPENPR:
lda #32         ;move checkmark
sta screen+301
lda #122
sta screen+221
ldx prname
ldy prname+1
jsr setnam      ;logical filename
lda #04
ldx #04
ldy #07
jsr setlfs      ;device, file, SA #'s
jsr open        ;open it
sta screen+233
jsr readst
ldx #4
jsr chkout      ;initialize LF#4
sta screen+273
jsr readst
sta screen+274
lda #0
sta ptr
lda #$70
sta ptr+1       ;bottom of buffer
rts

DOUBLECHECK:    ;make sure buffer is 0
jsr getin
sta carriage
jsr readst
and #8
cmp #8
beq D.OUT
lda carriage
and #127
tax
sec
sbc#31          ;just like TRANSLATE
bcc SMALL
tay
dey
lda array,y
jmp D.OK
SMALL:
txa
cmp #12
beq D.OK
cmp #13
bne DOUBLECHECK
D.OK:
ldy ystore
sta (bufptr),y
iny
sty ystore
jmp DOUBLECHECK
D.OUT:
ldy ystore
lda #$ff
sta (bufptr),y
rts

pstat:.asciz /Printer Status/
rstat:.asciz /RS 232 Status/
und:.byte 120
ostat:.asciz /Chan Open: /
istat:.asciz /Chan Init: /
cstat:.asciz /Chan Close:/
lstat:.asciz /Last Line Received:/
cord:.byte 0,0,0
astore:.byte 0
SETUP:
lda #32
ldy #0
LOOP = *        ;clearscreen
sta screen,y
sta screen+$0100,y
sta screen+$0200,y
sta screen+$02e7,y
iny
bne LOOP    ;these loop just set up the
lda #<rstat ;screen initially.
sta ptr     ;nothing fancy, just a lot
lda #>rstat ;of code._
sta ptr+1
lda #0
sta cord
ldy #3
ldx #2
jsr PUTS

lda #<pstat
sta ptr
lda #>pstat
sta ptr+1
lda #0
sta cord
ldy #22
ldx #2
jsr PUTS

lda #13
sta cord
ldy #3
ldx #3
lda #184 
sta astore
jsr UNDLN
lda #14
sta cord
ldy #22
ldx #3
jsr UNDLN

lda #<ostat
sta ptr
lda #>ostat
sta ptr+1
lda #0
sta cord
ldy #3
ldx #5
jsr PUTS
lda #0
sta cord
ldy #22
ldx #5
jsr PUTS

lda #<istat
sta ptr
lda #>istat
sta ptr+1
lda #0
sta cord
ldy #3
ldx #6
jsr PUTS
lda #0
sta cord
ldy #22
ldx #6
jsr PUTS

lda #<cstat
sta ptr
lda #>cstat
sta ptr+1
lda #0
sta cord
ldy #3
ldx #7
jsr PUTS
lda #0
sta cord
ldy #22
ldx #7
jsr PUTS

lda #<lstat
sta ptr
lda #>lstat
sta ptr+1
lda #0
sta cord
ldy #3
ldx #10
jsr PUTS

rts     
UNDLN:
clc
jsr plot
ldy cord
LOOP =*
lda astore
jsr putc
ldy cord
dey
sty cord
bne LOOP
rts

PUTS:
clc
jsr plot
ldy cord
lda (ptr),y
LOOP =*
jsr putc
ldy cord
iny
sty cord
lda (ptr),y
bne LOOP
rts
ldy #22
ldx #2
clc
jsr plot
ldy #0
sty cord
lda pstat
LOOP =*
jsr putc
ldy cord
iny
sty cord
lda pstat,y
bne LOOP

CLRLN:
ldy #80
lda #32
loop =*
sta screen +480, y 
dey
bne loop
rts

